function [image,Energies,Corr,Cut1,Cut2,MaxMin,Background,ShowDen,ShowDeconv,ShowDecSub,ZLP_load,MaxDrift,Logbook] = FineZLPAlign(handles)

global tracer

if isempty(tracer)
    tracer=1;
else
    image      = [];
    Energies   = [];
    Corr       = [];
    Cut1       = [];
    Cut2       = [];
    MaxMin     = [];
    Background = [];
    ShowDen    = [];
    ShowDeconv = [];
    ShowDecSub = [];
    ZLP_load   = [];
    MaxDrift   = [];
    Logbook    = [];
    clearvars -except image Energies Corr Cut1 Cut2 MaxMin Background ShowDen ShowDeconv ShowDecSub ZLP_load MaxDrift Logbook
    return
end

%% Load File
image      = load(fullfile(tempdir,'ShowOrg.mat')).image;
ShowDen    = load(fullfile(tempdir,'ShowDen.mat')).DenImg;
ShowDeconv = load(fullfile(tempdir,'ShowDeconv.mat')).DeconvImg;
ShowDecSub = load(fullfile(tempdir,'ShowDecSub.mat')).DeconvImg;

%% Get Handles
EnergyRes  = get(handles.Slider, 'SliderStep');
Corr       = get(handles.ShowDrift,'UserData');
FWHM       = get(handles.ShowFWHM,'UserData');
Energies   = get(handles.ZLPAlign,'UserData');
Background = get(handles.Background,'UserData');
ZLP_load   = get(handles.LoadPeak,'UserData');
Logbook    = get(handles.Logbook,'UserData');
EnergyRes  = EnergyRes(1);
StartPar   = get(handles.DiffMult,'UserData');
LWidth     = StartPar{1,2};
LStart     = StartPar{1,1};

%% Select ZLP region
% Allows the user to select a region in which all ZLP are to be found for
% faster alignment and to make the process less prone to cosmic rays.

Spec = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
Spec = max(Spec,[],1);

fig  = figure('Name','Select region with ZLP - double click to confirm!');
plot(Energies,Spec,'Color','b');
hold on
plot(Energies,zeros(size(Energies)),'--','Color','k');                     % dotted zero line
hold off
legend('mean Spectrum');
ylabel( 'Counts' );
xlabel( 'Loss energy [eV]' );
ylim([-max(Spec)/2,max(Spec).*1.25]);
xlim([min(Energies,[],2),max(Energies,[],2)]);
maxEne   = max(Spec,[],2);
minEne   = min(Spec,[],2);
ZLP      = (minEne + maxEne) / 10;
index1   = (find(Spec >= ZLP, 1, 'first'));
index2   = (find(Spec >= ZLP, 1, 'last'));
Start    = Energies(index1)- mean(FWHM,'all')*2;
Width    = Energies(index2)- Start + mean(FWHM,'all')*2;
Start    = max(Start,Energies(1));
if Start+Width > Energies(end)
    Width = Energies(end)-Start;
end

try
    Select  = drawrectangle('Position',[Start,-max(Spec)/2,Width,max(Spec)/2+max(Spec).*1.25],'Color','b','StripeColor','w');
    l       = addlistener(Select,'ROIClicked',@(src,evt) DoubleClicker(src,evt));
    uiwait;
    pos     = Select.Position;
    Ind1    = pos(1);
    Ind2    = pos(1)+pos(3);
    clearvars pos
    Ind1    = find(Energies>=Ind1,1,'first');
    Ind2    = find(Energies<=Ind2,1,'last');
    delete(Select);
    close(fig);
    delete(l);
catch
    image      = [];
    Energies   = [];
    Corr       = [];
    Cut1       = [];
    Cut2       = [];
    MaxMin     = [];
    Background = [];
    ShowDen    = [];
    ShowDeconv = [];
    ShowDecSub = [];
    ZLP_load   = [];
    MaxDrift   = [];
    Logbook    = [];
    clearvars -except image Energies Corr Cut1 Cut2 MaxMin Background ShowDen ShowDeconv ShowDecSub ZLP_load MaxDrift Logbook
    clear global
    return
end


%% Calculate Peak position
[~,ZeroPos] = min(abs(Energies));                                          % Gives position of the zero.

%% Cross Correlation function
SizeX      = size(image,2);
SizeY      = size(image,1);
SizeZ      = size(image,3);

Kernel      = reshape(image(:,:,Ind1:Ind2),[SizeY*SizeX,size(image(:,:,Ind1:Ind2),3)]);
Kernel      = Kernel./sum(Kernel,2);
Kernel      = mean(Kernel,1);
[~,Lag]     = CrossAlign(Kernel,Kernel);
[~,MaxPos]  = max(Kernel);
CorrShift   = ZeroPos-(MaxPos+Ind1-1);
Lag         = Lag - CorrShift;

Img         = reshape(image,[SizeY*SizeX,SizeZ]);
Img         = Img(:,Ind1:Ind2)./sum(Img,2);
[CF,~]      = CrossAlign(Img,Kernel);
clearvars Img
CF          = reshape(CF,[SizeY,SizeX,size(CF,2)]);

%% ZLP Alignment
% the ZLP is first defined by the user. To the region in between boundarys
% eighter a Gaussian function or a Nordheim-Fowler function is fitted,
% which compares the peak position to the energy dispersion.
% The spectra are shifted circulary by their respective ZLP position in
% relation to the 0 position of the energy dispersion. The FWHM as a output
% parameter is kept (in case of Gaussian fit), also the overall shift. Both can be seen in the
% FWHM and Drift map. However, with this curcular shift, shifts smaller
% than one dispersion step cannot be corrected. Thus the spectra is
% interpolated for higher precision alignment.

WaitTics = size(image,1);
WaitAlign = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);

CorrNew   = zeros([size(image,1),size(image,2)]);
CorrIP    = zeros([size(image,1),size(image,2)]);

Sigma     = mean(FWHM,'all')/(2*sqrt(2*log(2)));
options  = optimset('Display','none','TolFun',1e-5,'TolX',1e-5);

for i=1:size(image,1)
    for j=1:size(image,2)
        
        cf     = reshape(CF(i,j,:)   ,[1,size(CF   ,3)]);
        img    = reshape(image(i,j,:),[1,size(image,3)]);
        
        %% Correct Energies
        cf          = cf./max(cf);
        eqn         = @(x) sum((cf- x(1).*exp(-(Lag-x(2)).^2/(2.*x(3).^2))).^2);
        x           = [1,0,Sigma*2];
        x           = fminsearch(eqn,x,options);
        Shift       = x(2);
        
        if Shift > 10 || ~isreal(Shift)
            warndlg(['Fit too unstable for ZLP(',num2str(i),',',num2str(j),')!']);
            image      = [];
            Energies   = [];
            Corr       = [];
            Cut1       = [];
            Cut2       = [];
            MaxMin     = [];
            Background = [];
            ShowDen    = [];
            ShowDeconv = [];
            ShowDecSub = [];
            ZLP_load   = [];
            MaxDrift   = [];
            Logbook    = [];
            clearvars -except image Energies Corr Cut1 Cut2 MaxMin Background ShowDen ShowDeconv ShowDecSub ZLP_load MaxDrift Logbook
            clear global
            return
        end
        RShift       = round(Shift);
        SShift       = (Shift-RShift).*EnergyRes;
        
        img          = circshift(img,-RShift,3);
        image(i,j,:) = interp1(Energies-SShift,img,Energies,'linear');
        CorrNew(i,j) = Shift.*EnergyRes;
        CorrIP(i,j)  = SShift;
    end
    %% Check Waitbar exist
    Flag = CheckWaitbar1(WaitAlign);
    if Flag==1
        image      = [];
        Energies   = [];
        Corr       = [];
        Cut1       = [];
        Cut2       = [];
        MaxMin     = [];
        Background = [];
        ShowDen    = [];
        ShowDeconv = [];
        ShowDecSub = [];
        ZLP_load   = [];
        MaxDrift   = [];
        Logbook    = [];
        clearvars -except image Energies Corr Cut1 Cut2 MaxMin Background ShowDen ShowDeconv ShowDecSub ZLP_load MaxDrift Logbook
        clear global
        return
    end
    WaitAlign.Send;
    
end
WaitAlign.Destroy;

I = reshape(image,[size(image,1)*size(image,2),size(image,3)]);
I = sum(I,1);

[~,MaxPos] = max(I);
Shift      = ZeroPos - MaxPos;
image      = circshift(image,Shift,3);
CorrNew    = CorrNew - Shift.*EnergyRes;

%% Cut ends
% Due to the alignment, there are points at the boundarys of the spectra, that do not belong
% to their current energy position, as it was shifted circularry over the
% edge. E.g: a point belonging to -3eV is now circulary shifted to
% +20eV. To cut those points out, the maximum shift has to be found. Image
% and Dispersion then are corrected correspondingly.


Cut1     = floor(min(CorrNew,[],'all')/EnergyRes);
Cut2     =  ceil(max(CorrNew,[],'all')/EnergyRes);

CutIP1   = floor(min(CorrIP,[],'all')./EnergyRes);
CutIP2   =  ceil(max(CorrIP,[],'all')./EnergyRes);
    
Cut1     = min(Cut1,CutIP1);
Cut2     = max(Cut2,CutIP2);
EOld     = Energies;

if Cut2>0
    image    =  image(:,:,1:end-Cut2);
    Energies = Energies(:,1:end-Cut2);
end
if Cut1<0
    image    =  image(:,:,1-Cut1:end);
    Energies = Energies(:,1-Cut1:end);
end
Corr          = Corr + CorrNew;

if isempty(Energies)
    image      = [];
    Energies   = [];
    Corr       = [];
    Cut1       = [];
    Cut2       = [];
    MaxMin     = [];
    Background = [];
    ShowDen    = [];
    ShowDeconv = [];
    ShowDecSub = [];
    ZLP_load   = [];
    MaxDrift   = [];
    Logbook    = [];
    clearvars -except image Energies Corr Cut1 Cut2 MaxMin Background ShowDen ShowDeconv ShowDecSub ZLP_load MaxDrift Logbook
    clear global
    msgbox('FineAlign Failed!')
    return
end
MaxMin        = [Energies(end),Energies(1)];

%% Check other array lengths
% Due to the shortening of the image and energy arrays, the selected
% Background, a selected fit or ZLPSubtraction must be adjusted

if ~isempty(Background{2})
    if Cut1<0
        Background{2} = Background{2}+Cut1;
    end
end

if ~isempty(ShowDen)
    if Cut2>0
        ShowDen  =  ShowDen(:,:,1:end-Cut2);
    end
    if Cut1<0
        ShowDen  = ShowDen(:,:,-Cut1:end);
    end
end

if ~isempty(ShowDeconv)
    if Cut2>0
        ShowDeconv    =  ShowDeconv(:,:,1:end-Cut2);
    end
    if Cut1<0
        ShowDeconv    =  ShowDeconv(:,:,-Cut1:end);
    end
end
if ~isempty(ShowDecSub)
    if Cut2>0
        ShowDecSub    =  ShowDecSub(:,:,1:end-Cut2);
    end
    if Cut1<0
        ShowDecSub    =  ShowDecSub(:,:,-Cut1:end);
    end
end

if ~isempty(ZLP_load)
    if Cut2>0
        ZLP_load    =  ZLP_load(:,1:end-Cut2);
    end
    if Cut1<0
        ZLP_load    =  ZLP_load(:,-Cut1:end);
    end
end

if Cut1<0
    Cut1        = -Cut1;
else
    Cut1        = 0;
end

if Cut2<0
    Cut2        = 0;
end

MaxDrift     = max(abs(CorrNew),[],'all');
[row,col]    = find(abs(CorrNew)==MaxDrift);
MaxDrift     = CorrNew(row,col);

%% Create Logbook entry
Logbook{end+1} = ['FineAlign: Gauss Fit to Cross Correl. |  StartVal: ',num2str(EOld(Ind1)),'eV  |  EndVal: ',num2str(EOld(Ind2)),'eV  |  maxDrift: ',num2str(round(MaxDrift/EnergyRes,2).*EnergyRes),'eV'];

clearvars -except image Energies Corr MaxMin Background ShowDen ShowDeconv ShowDecSub ZLP_load MaxDrift Cut1 Cut2 Logbook
end